---
title: Lecture 43：多元函数的极值与最值
tags:
  - 数学
  - 多元函数
categories: 
date: 2024-02-07
---
**本节内容概要**
+ （一）无约束极值
+ （二）条件极值与拉格朗日乘数法
+ （三）最大、最小值

**本节常考题型**
+ 题型一：求极值（无条件）
+ 题型二：求最大最小值
+ 题型三：最大最小值的应用题
---
## 43.1 多元函数的无条件极值
### 43.1.1 基本概念
##### **定义**： #多元函数的极值
> <font color="#ccc1d9">描述：</font>在一个邻域中，多元函数的最大值或者最小值；
> 若在点 $(x_0,y_0)$ 的某邻域中恒成立不等式：$$f(x,y)\leq f(x_0,y_0)\quad(f(x,y)\geq f(x_0,y_0))$$
> 则称 f 在点 $(x_0,y_0)$ 取得极大值 (极小值)，点 $(x_0,y_0)$ 称为 `f` 的极大值点 (极小值点)；
> 极大值与极小值统称为极值，极大值点与极小值点统称为极值点；

**解释**
+ 举例
+ $z=3x^{2}+4y^{2}在(0.0)$ 处为极小值；
+ $z=-\sqrt{x^{2}+y^{2}}在\quad(0.0)$ 处为最大值

##### **定义**： #多元函数的驻点
> <font color="#ccc1d9">描述：</font>多元函数的偏导数等于 0 的点，称之为多元函数的驻点；

**解释**
+ $f_{x}^{\prime}=0.f_{y}^{\prime}=0$ 同时存在的点，称之为驻点；

##### **定理**： #多元函数极值存在的必要条件
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>如果 $z=f(x,y)$ 在点 $(x_0,y_0)$ 有偏导数，并且在 $(x_0,y_0)$ 处取得极值，则有：$$f_{x}^{\prime}(x_{0},y_{0})=0，f_{y}^{\prime}(x_{0},y_{0})=0$$

**解释**
+ 必要条件：
	+ 一点的两个一阶偏导数必须等于零，这是取得极值的必要条件，但**不是充分条件**；
	+ 缩小范围；
+ 驻点和极值点的关系：
	+ 一般情况下：
		+ 概念：
			+ 驻点不一定都是极值点；极值点也都不一定是驻点 `<-` 比如 $|x|+|y|$；
		+ 结论：
			+ 两种情况：可能的极值点
			+ （1）驻点 `<-` 主要是这种情况；
			+ （2）$f_x$ 和 $f_y$ 都不存在
			+ （3）$f_x$ 不存在，$f_y=0$
			+ （4）$f_y$ 不存在，$f_x=0$
	+ 可导的前提：
		+ 概念：
			+ 如果 $z=f(x,y)$ 可导的前提下，极值点一定是驻点； 
		+ 结论：
			+ 极值点只需要找驻点；
+ 

##### **定理**： #极值的充分条件 
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>**多元函数的驻点极值性判断**
> 当 $z=f(x,y)$ 在点 $P_0(x_0,y_0)$ 的某邻域内有二阶连续偏导数，又 $f_x^{\prime}(x_0,y_{0})=f_y^{\prime}(x_0,y_{0})=0$ 时，$A=f_{xx}^{\prime\prime}(x_{0},y_{0})\quad\quad B=f_{xy}^{\prime\prime}(x_{0},y_{0})\quad\quad C=f_{yy}^{\prime\prime}(x_{0},y_{0})$；
> 1. 如果是 $AC-B^{2}>0$，则有极值
> 	1. A<0，是极大值；
> 	2. A>0，是极小值；
> 2. 如果是 $AC-B^{2}<0$，则无极值
> 3. 如果是 $AC-B^{2}=0$，则只能用定义判断

**解释**：总结
+ 找到驻点后，只需要是不是极值，只需要使用这一个充分条件判断方法即可
### 43.1.2 例题
**例题**：求 $f(x,y)=x^{3}-y^{3}+3x^{2}+3y^{2}-9x$ 的极值；
+ 分析
+ 解析
	+ 分别求偏导：
		+ $f_{x}^{\prime}=3x^{2}+6x-9$
		+ $f_{y}^{\prime}=-3y^{2}+6y$
	+ 得到
		+ $\begin{cases}x^{2}+2x-3=0\\-y^{2}+2y=0\end{cases}$
	+ 化简
		+ $(x+3)(x-1)=0$ 时，$x=-3或1$；
		+ $y(y-2)=0$ 时，$y=0或2$；
	+ 排列组合，得到驻点
		+ $(1,0),(1,2),(-3,0),(-3,2)$
	+ 求 A、B、C
		+ $f_{xx}^{\prime\prime}=6x+6$
		+ $f_{xy}^{\prime\prime}=0$
		+ $f_{yy}^{\prime\prime}=-6y+6$
	+ 当 (1,0)点时：
		+ $A=12.B=0.C=6$
		+ 所以 $AC-B^{2}=72>0$
		+ 所以是极小值点，即带入 $(1,0)$ 后得到的结果-5，为极小值点；
	+ 其他的同理
+ 题型： #多元函数的极值 

## 43.2 多元函数的条件极值：拉格朗日乘数法
### 43.2.1 基本概念
**无条件极值与条件极值**
+ 无条件
	+ 举例：找全校最高的人
+ 有条件
	+ 举例：找全校最高的、山东的、双子座的同学；
+ 加多条件越多，最值就越小

##### **定义**： #条件极值
> <font color="#ccc1d9">描述：</font>已知 $z=f(x,y)$，其极值在 $\varphi(x,y)=0$ 的条件之下，求其极值为条件极值；

**解释**
+ 和无约束极值的区别：
	+ 无约束极值：在定义域内上的极值，即在定义域内、局部的最高或者最低点；
	+ 有约束极值：有约束的内容 $\varphi (x, y)=0$ 在几何上通常是一条线，即在一条曲线上、局部最低和局部最高；
+ 举例： 
	+ 在 $z=f(x,y)$ 中： $z=f(x,\varphi(x))$
	+ 其中用 z 对 x 求导：$\frac{dz}{dx}=\frac{\partial f}{\partial x}+\frac{\partial f}{\partial y}\cdot\frac{dy}{dx}$ 
	+ 写出 $\frac{dz}{dx}\vert_{x=x_{0}}=f^{\prime}(x_{0},y)+f^{\prime}(x_{0},y)\frac{dy}{dx}\vert_{x=x_{0}}=0$

##### **定理**： #拉格朗日乘数法
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>
> （1）单个约束条件时：令 $F(x,y,\lambda)=f(x,y)+\lambda\varphi(x,y)$
> 	 则取到极值的必要条件为：$$\begin{cases}F_x=f_x^{\prime}(x,y)+\lambda\varphi_x^{\prime}(x,y)=0,\\F_y=f_y^{\prime}(x,y)+\lambda\varphi_y^{\prime}(x,y)=0,\\F_\lambda=\varphi(x,y)=0,\end{cases}$$
>  （2）多个约束条件时：$f(x,y,z)\text{ 在条件 }\varphi(x,y,z)=0,\psi(x,y,z)=0$ 条件下的条件极值
> 	  令 $F(x,y,z,\lambda,\mu)=f(x,y,z)+\lambda\varphi(x,y,z)+\mu\psi(x,y,z)$

**解释**
+ 解释：
	+ $\lambda$ 是一个参数
+ 意义：
	+ 将二元函数在约束前提下的取得条件极值的必要条件，转化为大 `F` 这样一个三元函数的无条件极值的必要条件问题 `->` 对三个偏导数等于 0；
+ 注意：
	+ 这个约束条件解出来的点，得到的点是可能取得的极值点，而不是一定；

##### **定理**： #n元拉格朗日乘数法
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>以上方法可推广到对于 $n$ 元函数在 $m$ 个约束条件下的极值问题，
> 如求 $u=f(x,y,z)$ 在条件 $\varphi(x,y,z)=0,\psi(x,y,z)=0$ 下的极值，可构造拉格朗日函数：$$F(x,y,z,\lambda,\mu)=f(x,y,z)+\lambda\varphi(x,y,z)+\mu\psi(x,y,z).$$ 对 $F$ 的 $x,y,z,\lambda,\mu$ 分别求偏导数，并构造方程组：$$\begin{aligned}&f_{x}^{\prime}(x,y,z)+\lambda\varphi_{x}^{\prime}(x,y,z)+\mu\psi_{x}^{\prime}(x,y,z)=0,\\&f_{y}^{\prime}(x,y,z)+\lambda\varphi_{y}^{\prime}(x,y,z)+\mu\psi_{y}^{\prime}(x,y,z)=0,\\&f_{z}^{\prime}(x,y,z)+\lambda\varphi_{z}^{\prime}(x,y,z)+\mu\psi_{z}^{\prime}(x,y,z)=0,\\&\varphi(x,y,z)=0,\\&\psi(x,y,z)=0.\end{aligned}$$解出 $x,y,z,\lambda$ 及 $\mu$,则其中 ($x,y,z)$ 就是**可能的极值点**.


## 43.3 多元函数的最大最小值
### 43.3.1 基本概念
**总结**：求连续函数 `f(x, y)` 在有界闭域 `D` 上的最大最小值
+ 第一步：求 `f(x, y)` 在 `D` 内部可能的极值点；
	+ （1）驻点；
	+ （2）两个一阶偏导数，至少有一个不存在的点
+ 第二步：求 `f(x, y)` 在 `D` 的**边界**上的最大最小值；
	+ 求边界上的最大最小 `->` 其实就是求一个条件极值；
+ 第三步：比较各个极值；


### 44.3.2 条件最值问题

## 43.3 常考题型 

---
### 题型： #求极值
#### PART 1：解题方法
**题型**：知道函数的全微分，判断极值
+ 求解指导：
	+ 一般先使用方法三或方法一；
+ 方法一：极值的充分条件
	+ 利用极值的充分条件。先利用全微分，知道对 `x` 以及对 `y` 的偏导数，然后使用偏导数，分别求 `A、B、C` 的值，利用公式判断；
+ 方法二：偏积分
	+ 核心：知道全微分 `->` 使用偏积分求函数；
	+ 举例：当二元函数 $z=f(x,y)$ 的全微分为 $dz = xdx + ydy$ 时，可以求其偏微分
		+ $z_{x}=x\quad\quad z=\int xdx=\frac{1}{2}x^{2}+q(y)$
		+ $z_{y}=y \quad\quad z_{y}=q^{\prime}(y)=y,q(y)=\frac{1}{2}y^{2}+c$
		+ 所以 $z=\frac{1}{2}(x^{2}+y^{2})+c$
+ 方法三：凑微分
	+ 核心：知道全微分 `->` 使用微分概念凑微分 `->` 得到原函数；
	+ 举例：$dz=xdx+ydy=d(\frac{1}{2}x^2)+d(\frac{1}{2}y^{2})=d(\frac{1}{2}(x^{2}+y^{2}))$
		+ 因为微分相等，因此两者只能相差常数，所以 $z=\frac{1}{2}(x^{2}+y^{2})+c$

**题型**：知道函数形式，求极值点
+ （1.1）没给可能的极值点：
	+ 对函数的 x、y 分别求偏导，令其偏导等于 0，找出可能的驻点（如果没给出可能的极值点）
+ （1.2）给了可能的极值点：
	+ 利用必要条件判断 `->` 判断是否是驻点：
	+ 极值点存在的必要条件 `->` $f_{x}^{\prime}(x_{0},y_{0})=0，f_{y}^{\prime}(x_{0},y_{0})=0$
+ （2）充分条件判断：利用 ABC 公式判断
+ 注意：
	+ 如果计算 ABC 很麻烦时，可以“先代后求” `->` 对 Y 求时，先把 X 带入进去，同理对 X 时；

#### PART 2：典型例题

#### PART 3：知识点复盘


---
### 题型： #条件极值与拉格朗日乘数法
#### PART 1：解题方法
**题型**：条件最值问题
+ 概念：
	+ 使用拉格朗日乘数法，把函数所有可能取得的极值点先找来，然后不需要判定、把所有可能的极值点做一个比较，得到最值；
+ 解题步骤：
	+ （1）构造拉格朗日函数；
	+ （2）求偏导；
	+ （3）找驻点；
		+ 得到几个等于 0 的等式，根据等式求解 x、y 可能的取值；
	+ （4）对每个点比较，判断最大值和最小值； 

**题型**：已知全微分，求最值
+ 方法： 
+ （1）先根据全微分，求出原函数；
	+ 两种方法 `->` 偏积分、凑微分；
+ （2）求出区域的最值点；
	+ 1. 区域内部的可能极值点；
	+ 2. 边界曲线上的最大最小值；
		+ 方法一： 
			+ 利用条件，将条件极值化成无约束极值；
		+ 方法二： 
			+ 一般方法，是拉格朗日乘数法；
		+ 方法三： 
			+ 参数方程
	+ 3. 把边界上的最大最小值，和区域内部可能的极值进行比较；

#### PART 2：典型例题

#### PART 3：知识点复盘